/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import xzeroair.trinkets.capabilities.CapabilityStorage;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerStorage;
import xzeroair.trinkets.capabilities.TileEntityCap.TileEntityProperties;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.container.TrinketContainerHandler;

public class Capabilities {
    @CapabilityInject(value=TileEntityProperties.class)
    public static Capability<TileEntityProperties> TILE_ENTITY_PROPERTIES;
    @CapabilityInject(value=StatusHandler.class)
    public static Capability<StatusHandler> STATUS_HANDLER;
    @CapabilityInject(value=EntityProperties.class)
    public static Capability<EntityProperties> ENTITY_PROPERTIES;
    @CapabilityInject(value=TrinketProperties.class)
    public static Capability<TrinketProperties> ITEM_TRINKET;
    @CapabilityInject(value=VipStatus.class)
    public static Capability<VipStatus> VIP_STATUS;
    @CapabilityInject(value=MagicStats.class)
    public static Capability<MagicStats> ENTITY_MAGIC;

    public static void init() {
        Capabilities.registerNewCap(ITrinketContainerHandler.class, TrinketContainerStorage.storage, new TrinketContainerFactory());
        Capabilities.registerNewCap(EntityProperties.class, new CapabilityStorage());
        Capabilities.registerNewCap(MagicStats.class, new CapabilityStorage());
        Capabilities.registerNewCap(StatusHandler.class, new CapabilityStorage());
        Capabilities.registerNewCap(VipStatus.class, new CapabilityStorage());
        Capabilities.registerNewCap(TrinketProperties.class, new CapabilityStorage());
        Capabilities.registerNewCap(TileEntityProperties.class, new CapabilityStorage());
    }

    public static TileEntityProperties getTEProperties(TileEntity tileEntity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)tileEntity, TILE_ENTITY_PROPERTIES, null);
    }

    public static TileEntityProperties getTEProperties(TileEntity tileEntity, Consumer<TileEntityProperties> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)tileEntity, TILE_ENTITY_PROPERTIES, consumer);
    }

    public static <R> R getTEProperties(TileEntity tileEntity, R ret, BiFunction<TileEntityProperties, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)tileEntity, TILE_ENTITY_PROPERTIES, ret, func);
    }

    public static StatusHandler getStatusHandler(Entity entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, STATUS_HANDLER, null);
    }

    public static StatusHandler getStatusHandler(Entity entity, Consumer<StatusHandler> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, STATUS_HANDLER, consumer);
    }

    public static <R> R getStatusHandler(Entity entity, R ret, BiFunction<StatusHandler, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, STATUS_HANDLER, ret, func);
    }

    public static EntityProperties getEntityProperties(Entity entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, ENTITY_PROPERTIES, null);
    }

    public static EntityProperties getEntityProperties(Entity entity, Consumer<EntityProperties> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, ENTITY_PROPERTIES, consumer);
    }

    public static <R> R getEntityProperties(Entity entity, R ret, BiFunction<EntityProperties, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, ENTITY_PROPERTIES, ret, func);
    }

    @Deprecated
    public static EntityProperties getEntityRace(Entity entity) {
        return Capabilities.getEntityProperties(entity);
    }

    public static TrinketProperties getTrinketProperties(ItemStack stack) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)stack, ITEM_TRINKET, null);
    }

    public static TrinketProperties getTrinketProperties(ItemStack stack, Consumer<TrinketProperties> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)stack, ITEM_TRINKET, consumer);
    }

    public static <R> R getTrinketProperties(ItemStack stack, R ret, BiFunction<TrinketProperties, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)stack, ITEM_TRINKET, ret, func);
    }

    public static VipStatus getVipStatus(Entity entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, VIP_STATUS, null);
    }

    public static VipStatus getVipStatus(Entity entity, Consumer<VipStatus> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, VIP_STATUS, consumer);
    }

    public static <R> R getVipStatus(Entity entity, R ret, BiFunction<VipStatus, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, VIP_STATUS, ret, func);
    }

    public static MagicStats getMagicStats(Entity entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, ENTITY_MAGIC, null);
    }

    public static MagicStats getMagicStats(Entity entity, Consumer<MagicStats> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, ENTITY_MAGIC, consumer);
    }

    public static <R> R getMagicStats(Entity entity, R ret, BiFunction<MagicStats, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, ENTITY_MAGIC, ret, func);
    }

    @Nullable
    public static <C> C getCapability(ICapabilitySerializable object, Capability<C> capability) {
        if (object != null) {
            return (C)object.getCapability(capability, null);
        }
        return null;
    }

    @Nullable
    public static <C> C getCapabilityWithConsumer(ICapabilitySerializable object, Capability<C> capability, Consumer<C> consumer) {
        C cap = Capabilities.getCapability(object, capability);
        if (cap != null) {
            if (consumer != null) {
                try {
                    consumer.accept(cap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return cap;
        }
        return null;
    }

    @Nullable
    public static <C, R> R getCapabilityWithReturn(ICapabilitySerializable object, Capability<C> capability, R ret, BiFunction<C, R, R> func) {
        C cap = Capabilities.getCapability(object, capability);
        if (cap != null && func != null) {
            try {
                return func.apply(cap, ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static ITrinketContainerHandler getTrinketContainer(Entity entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, TrinketContainerProvider.containerCap, null);
    }

    public static ITrinketContainerHandler getTrinketContainer(Entity entity, Consumer<ITrinketContainerHandler> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, TrinketContainerProvider.containerCap, consumer);
    }

    public static <R> R getTrinketContainer(Entity entity, R ret, BiFunction<ITrinketContainerHandler, R, R> func) {
        return Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, TrinketContainerProvider.containerCap, ret, func);
    }

    private static <T> void registerNewCap(Class<T> type) {
        Capabilities.registerNewCap(type, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static <T> void registerNewCap(Class<T> type, Capability.IStorage<T> storage) {
        Capabilities.registerNewCap(type, storage, () -> null);
    }

    private static <T> void registerNewCap(Class<T> type, Capability.IStorage<T> storage, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, storage, factory);
    }

    private static class TrinketContainerFactory
    implements Callable<ITrinketContainerHandler> {
        private TrinketContainerFactory() {
        }

        @Override
        public ITrinketContainerHandler call() throws Exception {
            return new TrinketContainerHandler();
        }
    }
}

